﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using Mdws2ORM.Core;
using Mdws2ORM.RpcQueries;
using Mdws2ORM.Impl;
using BMS.VistaIntegration.Data;

namespace Mdws2ORM.SessionFactory.Concrete
{
    public abstract class MdwsSessionFactory : ISessionFactory
    {
        private readonly EntityMapRepository entityMapRepository = new EntityMapRepository();
        private readonly IFieldsParamFactory fieldsParamFactory;
        private readonly InitMapMediator initMediator;

        public abstract IFieldsParamFactory MakeFieldsParamFactory();
        public abstract IEntryQuery MakeEntryQuery(QuerySvcSoap client, VistASite vistaSite);

        public MdwsSessionFactory()
        {
            fieldsParamFactory = MakeFieldsParamFactory();
            initMediator = new InitMapMediator(entityMapRepository, fieldsParamFactory);
        }

        public void Add<T>(BaseEntityMap<T> entityMap) where T : class
        {
            entityMapRepository.Add<T>(entityMap);
        }

        public void Initialize()
        {
            entityMapRepository.EntityMaps.ForEach(s => s.Initialize(initMediator));
        }

        private Session CreateSession(ICache cache, QuerySvcSoap client, VistASite vistaSite)
        {
            IEntryQuery entryQuery = MakeEntryQuery(client, vistaSite);
            Session session = new Session(cache, entryQuery,  initMediator, vistaSite);
            return session;
        }

        public ISession CreateSession(QuerySvcSoap client, VistASite vistaSite)
        {
            return CreateSession(new Cache(), client, vistaSite);
        }


    }
}
